function pdfs = calcPdfs(data, opts)
	pdfs = struct();

	% get class boundaries
	Astar = 10.^linspace(log10(opts.zoneLimits(1)), log10(opts.zoneLimits(2)), opts.zoneClasses + 1);
	Astar = Astar';

	AstarRight = Astar(2:end);
	AstarLeft  = Astar(1:end-1);
	Astar = (AstarLeft + AstarRight) / 2;

	% calculate pdf


    for n = 1:numel(data)
		% allocate
		Lw = NaN(opts.zoneClasses, 1);
		Ld = NaN(opts.zoneClasses, 1);

		% calculate classes
		for c = 1:opts.zoneClasses
			id = data(n).area >= AstarLeft(c); %era >= inizialmente, modifico con <=

			Lw(c) = sum(data(n).length(id & data(n).class == 0));
			Ld(c) = sum(data(n).length(id & data(n).class == 1));
		end

		Lt = Lw + Ld;
		Pd = Ld ./ Lt;

        % remove NaN
        id = Lt >  0;
        AstarLeft = AstarLeft(id);
        Astar = Astar(id);
        AstarRight = AstarRight(id);
        Lw = Lw(id);
        Ld = Ld(id);
        Lt = Lt(id);
        Pd = Pd(id);

		% save
		pdfs(n).AstarLeft = AstarLeft;
		pdfs(n).Astar = Astar;
		pdfs(n).AstarRight = AstarRight;

		pdfs(n).LwAcc = Lw;
		pdfs(n).LdAcc = Ld;
		pdfs(n).LtAcc = Lt;
		pdfs(n).PdAcc = Pd;

		pdfs(n).Lw = -(Lw - [0; Lw(1:end-1)]);
		pdfs(n).Ld = -(Ld - [0; Ld(1:end-1)]);
		pdfs(n).Lt = -(Lt - [0; Lt(1:end-1)]);
		pdfs(n).Pd = pdfs(n).Ld ./ pdfs(n).Lt;

    end

end




